
// SSM4データを親ウィンドウに要求するメソッド
function getCurrentSSM4() {
    if (parent == window) {
        if (window.chrome) {
            opener.postMessage({ getCurrentSSM4: "" }, '*');
        } else {
            opener.getCurrentSSM4(this);
        }
    } else {
        if (isIE() == 9) {
            parent.postMessage("{getCurrentSSM4:\"\"}", '*');
        }
        else {
            parent.postMessage({ getCurrentSSM4: "" }, '*');
        }
    }
}

// メッセージ受信メソッド
function receiveMessage(event) {
    // for IE9 (When IE9, send the data as string)
    var eventData = event.data;
    if (typeof eventData == 'string') {
        try {
            eventData = eval('(' + eventData + ')');
        }
        catch (e) {
        }
    }

    if (typeof eventData.setCurrentSSM4 != 'undefined') {
        setCurrentSSM4(eventData.setCurrentSSM4);
    }
}

// 受け取ったSSM4データを処理するメソッド
function setCurrentSSM4(data) {
    $(".ssm4-placeholder.ssm4-get-dtc").empty();
    $('#ssm4-get-dtc-initial-template').tmpl().appendTo('.ssm4-placeholder.ssm4-get-dtc');
    $(".ssm4-placeholder.ssm4-monitor-data").empty();
    $('#ssm4-monitor-data-initial-template').tmpl().appendTo('.ssm4-placeholder.ssm4-monitor-data');
    $(".ssm4-placeholder.ssm4-clear-memory").empty();
    $('#ssm4-clear-memory-initial-template').tmpl().appendTo('.ssm4-placeholder.ssm4-clear-memory');
    $(".ssm4-placeholder.ssm4-get-readiness").empty();
    $('#ssm4-get-readiness-initial-template').tmpl().appendTo('.ssm4-placeholder.ssm4-get-readiness');
    $(".ssm4-placeholder.ssm4-get-ffd").empty();
    $('#ssm4-get-ffd-initial-template').tmpl().appendTo('.ssm4-placeholder.ssm4-get-ffd');

    if (data.ManualCooperationCheckDTCResponse) {
        for (var i = 0; i < data.ManualCooperationCheckDTCResponse; i++) {
            var indexData = data['ManualCooperationCheckDTCResponse' + i];
            if (indexData) {
                $('.ssm4-placeholder.ssm4-get-dtc:eq(' + i + ')').empty();
                $('#ssm4-get-dtc-result-template').tmpl(indexData).appendTo('.ssm4-placeholder.ssm4-get-dtc:eq(' + i + ')');
            }
        }
    }
    if (data.ManualCooperationDataMonitorResponse) {
        for (var i = 0; i < data.ManualCooperationDataMonitorResponse; i++) {
            var indexData = data['ManualCooperationDataMonitorResponse' + i];
            if (indexData) {
                $('.ssm4-placeholder.ssm4-monitor-data:eq(' + i + ')').empty();
                $('#ssm4-monitor-data-result-template').tmpl(indexData).appendTo('.ssm4-placeholder.ssm4-monitor-data:eq(' + i + ')');
            }
        }
    }
    if (data.ManualCooperationClearDTCResponse) {
        for (var i = 0; i < data.ManualCooperationClearDTCResponse; i++) {
            var indexData = data['ManualCooperationClearDTCResponse' + i];
            if (indexData) {
                $('.ssm4-placeholder.ssm4-clear-memory:eq(' + i + ')').empty();
                $('#ssm4-clear-memory-result-template').tmpl(indexData).appendTo('.ssm4-placeholder.ssm4-clear-memory:eq(' + i + ')');
            }
        }
    }
    if (data.ManualCooperationGetReadinessResponse) {
        for (var i = 0; i < data.ManualCooperationGetReadinessResponse; i++) {
            var indexData = data['ManualCooperationGetReadinessResponse' + i];
            if (indexData) {
                $('.ssm4-placeholder.ssm4-get-readiness:eq(' + i + ')').empty();
                $('#ssm4-get-readiness-result-template').tmpl(indexData).appendTo('.ssm4-placeholder.ssm4-get-readiness:eq(' + i + ')');
            }
        }
    }
    if (data.ManualCooperationGetFfdResponse) {
        for (var i = 0; i < data.ManualCooperationGetFfdResponse; i++) {
            var indexData = data['ManualCooperationGetFfdResponse' + i];
            if (indexData) {
                $('.ssm4-placeholder.ssm4-get-ffd:eq(' + i + ')').empty();
                $('#ssm4-get-ffd-result-template').tmpl(indexData).appendTo('.ssm4-placeholder.ssm4-get-ffd:eq(' + i + ')');
            }
        }
    }

    setTitleAndPrint();
}